<?php


namespace Gek\Collections\Tests\Traits;


use Gek\Collections\Tests\Fixtures\MockForTypedCollectionTrait;
use Gek\Collections\Tests\Fixtures\MockRefObj;
use PHPUnit\Framework\TestCase;

/**
 * Class TypedCollectionTraitTest
 * @package Gek\Collections\Tests\Traits
 */
class TypedCollectionTraitTest extends TestCase
{

    public function testInitalizeType():void {
        $mock = new MockForTypedCollectionTrait();
        $this->assertTrue(
            $mock->initalize('int')
        );
        $this->assertTrue(
            $mock->initalize('integer')
        );
        $this->assertTrue(
            $mock->initalize('float')
        );
        $this->assertTrue(
            $mock->initalize('bool')
        );
        $this->assertTrue(
            $mock->initalize('boolean')
        );
        $this->assertTrue(
            $mock->initalize('string')
        );
        $this->assertTrue(
            $mock->initalize('callable')
        );
        $this->assertTrue(
            $mock->initalize('array')
        );
        $this->assertTrue(
            $mock->initalize('object')
        );
        $this->assertTrue(
            $mock->initalize('Gek\Collections\Tests\Fixtures\MockRefObj')
        );
        $this->assertFalse(
            $mock->initalize('Gek\Collections\Tests\Fixtures\InvalidTypeName')
        );


    }

    public function testIsScalarItemType():void {
        $mock = new MockForTypedCollectionTrait();
        $mock->initalize('int');
        $this->assertTrue(
           $mock->isScalarItemType()
        );

        $mock = new MockForTypedCollectionTrait();
        $mock->initalize('float');
        $this->assertTrue(
            $mock->isScalarItemType()
        );

        $mock = new MockForTypedCollectionTrait();
        $mock->initalize('bool');
        $this->assertTrue(
            $mock->isScalarItemType()
        );

        $mock = new MockForTypedCollectionTrait();
        $mock->initalize('string');
        $this->assertTrue(
            $mock->isScalarItemType()
        );

        $mock = new MockForTypedCollectionTrait();
        $mock->initalize('callable');
        $this->assertTrue(
            $mock->isScalarItemType()
        );

        $mock = new MockForTypedCollectionTrait();
        $mock->initalize('object');
        $this->assertTrue(
            $mock->isScalarItemType()
        );

        $mock = new MockForTypedCollectionTrait();
        $mock->initalize('array');
        $this->assertTrue(
            $mock->isScalarItemType()
        );

        $mock = new MockForTypedCollectionTrait();
        $mock->initalize('Gek\Collections\Tests\Fixtures\MockRefObj');
        $this->assertFalse(
            $mock->isScalarItemType()
        );

    }

    public function testGetItemType():void {
        $mock = new MockForTypedCollectionTrait();
        $mock->initalize('callable');
        $this->assertEquals(
            'callable',
            $mock->getItemType()
        );

        $mock = new MockForTypedCollectionTrait();
        $mock->initalize('INTEGER');
        $this->assertEquals(
            'int',
            $mock->getItemType()
        );

        $mock = new MockForTypedCollectionTrait();
        $mock->initalize('Boolean');
        $this->assertEquals(
            'bool',
            $mock->getItemType()
        );

        $mock = new MockForTypedCollectionTrait();
        $mock->initalize(MockRefObj::class);
        $this->assertEquals(
            MockRefObj::class,
            $mock->getItemType()
        );

    }

}
