<?php


namespace Gek\Collections\Tests;


use Gek\Collections\FixedArrayHelper;
use PHPUnit\Framework\TestCase;
use SplFixedArray;

/**
 * Class FixedArrayHelperTest
 * @package Gek\Collections\Tests
 */
class FixedArrayHelperTest extends TestCase
{

    public function testFloatLeft():void {
        $splArr = SplFixedArray::fromArray(range(0,10));
        FixedArrayHelper::floatLeft($splArr,0,5);
        $this->assertEquals(
            [
                0 => 5,
                1 => 6,
                2 => 7,
                3 => 8,
                4 => 9,
                5 => 10,
                6 => null,
                7 => null,
                8 => null,
                9 => null,
                10 => null
            ],
            $splArr->toArray()
        );

        $splArr = SplFixedArray::fromArray(range(0,10));
        FixedArrayHelper::floatLeft($splArr,5,5);
        $this->assertEquals(
            [
                0 => 0,
                1 => 1,
                2 => 2,
                3 => 3,
                4 => 4,
                5 => 10,
                6 => null,
                7 => null,
                8 => null,
                9 => null,
                10 => null
            ],
            $splArr->toArray()
        );

        $splArr = SplFixedArray::fromArray(range(0,10));
        FixedArrayHelper::floatLeft($splArr,0,5);
        $this->assertEquals(
            [
                0 => 5,
                1 => 6,
                2 => 7,
                3 => 8,
                4 => 9,
                5 => 10,
                6 => null,
                7 => null,
                8 => null,
                9 => null,
                10 => null
            ],
            $splArr->toArray()
        );

        $splArr = SplFixedArray::fromArray(range(0,10));
        FixedArrayHelper::floatLeft($splArr,0,10);
        $this->assertEquals(
            [
                0 => 10,
                1 => null,
                2 => null,
                3 => null,
                4 => null,
                5 => null,
                6 => null,
                7 => null,
                8 => null,
                9 => null,
                10 => null
            ],
            $splArr->toArray()
        );

    }

    public function testFloatRight():void {
        $splArr = SplFixedArray::fromArray(range(0,10));
        FixedArrayHelper::floatRight($splArr,0,5);
        $this->assertEquals(
            [
                0 => null,
                1 => null,
                2 => null,
                3 => null,
                4 => null,
                5 => 0,
                6 => 1,
                7 => 2,
                8 => 3,
                9 => 4,
                10 => 5,
                11 => 6,
                12 => 7,
                13 => 8,
                14 => 9,
                15 => 10
            ],
            $splArr->toArray()
        );

        $splArr = SplFixedArray::fromArray(range(0,10));
        FixedArrayHelper::floatRight($splArr,5,5);
        $this->assertEquals(
            [
                0 => 0,
                1 => 1,
                2 => 2,
                3 => 3,
                4 => 4,
                5 => null,
                6 => null,
                7 => null,
                8 => null,
                9 => null,
                10 => 5,
                11 => 6,
                12 => 7,
                13 => 8,
                14 => 9,
                15 => 10
            ],
            $splArr->toArray()
        );

        $splArr = SplFixedArray::fromArray(range(0,10));
        FixedArrayHelper::floatRight($splArr,10,5);
        $this->assertEquals(
            [
                0 => 0,
                1 => 1,
                2 => 2,
                3 => 3,
                4 => 4,
                5 => 5,
                6 => 6,
                7 => 7,
                8 => 8,
                9 => 9,
                10 => null,
                11 => null,
                12 => null,
                13 => null,
                14 => null,
                15 => 10
            ],
            $splArr->toArray()
        );

    }

}
