<?php


namespace Gek\Collections\Typed;


use Gek\Collections\Dictionary;
use Gek\Collections\Enumerable;
use Gek\Collections\TypedDictionaryWrapper;

/**
 * Class FloatDictionary
 * @package Gek\Collections\Typed
 */
class FloatDictionary extends TypedDictionaryWrapper
{

    #region ctor
    /**
     * FloatDictionary constructor.e
     * @param Dictionary|array|Enumerable|\Traversable|null $values
     */
    public function __construct($values = null)
    {
        parent::__construct(new Dictionary(), 'float');
        if($values != null)
        {
            $this->addRange($values);
        }
    }
    #endregion ctor

    #region methods

    /**
     * @param float $item
     */
    public function add(float $item):void {
        $this->innerDictionary->add($item);
    }


    /**
     * @param Dictionary|array|Enumerable|\Traversable $items
     */
    public function addRange($items): void
    {
        foreach ($items as $key => $value){
            $this->addKeyValue($key,$value);
        }
    }

    /**
     * @param float $item
     * @return bool
     */
    public function contains(float $item): bool{
        return $this->innerDictionary->contains($item);
    }

    /**
     * @param float $item
     * @return bool
     */
    public function remove(float $item): bool{
        return $this->innerDictionary->remove($item);
    }

    /**
     * @param string $key
     * @param float $value
     */
    public function addKeyValue(string $key, float $value): void{
        $this->innerDictionary->addKeyValue($key,$value);
    }

    /**
     * @param string $key
     * @param float $value
     * @return bool
     */
    public function tryAddKeyValue(string $key, float $value):bool{
        return $this->innerDictionary->tryAddKeyValue($key,$value);
    }

    /**
     * @param string $key
     * @return float
     */
    public function getByKey(string $key):float {
        return $this->innerDictionary[$key];
    }

    /**
     * @param string $key
     * @param float $item
     */
    public function setByKey(string $key, float $item):void {
        $this->innerDictionary[$key] = $item;
    }

    #endregion methods

}
