<?php


namespace Gek\Collections;


use ArrayAccess;

/**
 * Interface IList
 * @package Gek\Collections
 */
interface IList extends ICollection, ArrayAccess
{

    /**
     * @param mixed $item
     * @return int
     */
    public function indexOf($item): int;

    /**
     * @param int $index
     * @param mixed $item
     */
    public function insert(int $index, $item): void;

    /**
     * @param int $index
     * @param array|Enumerable|\IteratorAggregate|\Iterator|\Traversable $items
     */
    public function insertRange(int $index, $items):void;

    /**
     * @param int $index
     */
    public function removeAt(int $index): void;

    /**
     * @param int $index
     * @param int $count
     */
    public function removeRange(int $index, int $count):void;

    /**
     * @param callable $fn
     * @return int
     */
    public function removeAll(callable $fn):int;

}
