<?php


namespace Gek\Collections;

use Gek\Infrastructure\Exceptions\ArgumentOutOfRangeException;
use Gek\Infrastructure\Str;
use SplFixedArray;

/**
 * Class FixedArrayHelper
 * @package Gek\Collections
 * @internal
 */
class FixedArrayHelper
{

    /**
     * $offset ten başlayarak öğeleri $length sayısınca sola kaydırır.
     * @param SplFixedArray $splArray
     * @param int $offset
     * @param int $length
     */
    public static function floatLeft(SplFixedArray $splArray, int $offset, int $length): void
    {


        $count = $splArray->count();
        if($offset < 0 || $offset >= $count){
            throw new ArgumentOutOfRangeException(
                Str::format('Geçersiz ofset : {0}', $offset),
                0,
                null,
                '$offset'
            );
        }
        if(($offset + $length) >= $count){
            throw new ArgumentOutOfRangeException(
                Str::format('GUzunluk değeri dizi sınırını aşıyor. $length . {0}', $length),
                0,
                null,
                '$length'
            );
        }

        for ($i = $offset + $length; $i < $count; $i++) {
            $newIndex = $i - $length;
            if ($newIndex < 0) {
                continue;
            }
            $tmpItem = $splArray[$i];
            $splArray[$newIndex] = $tmpItem;
            unset($splArray[$i]);
        }

        for($j =  $count - $length; $j < $count; $j++){
            unset($splArray[$j]);
        }
    }

    /**
     * son öğeden  başlayarak öğeleri $offset e ulaşana kadar $length sayısınca sağa kaydırır.
     * @param SplFixedArray $splArray
     * @param int $offset
     * @param int $length
     * @param int|null $countLimit
     */
    public static function floatRight(SplFixedArray $splArray, int $offset, int $length, ?int $countLimit = null): void
    {

        $count = $splArray->count();
        if ($offset >= $count) {
            throw new ArgumentOutOfRangeException(
                Str::format('Geçersiz ofset: {0}', $offset),
                0,
                null,
                '$offset'
            );
        }
        if($countLimit !== null){
            if(($countLimit + $length) > $count){
                $splArray->setSize($countLimit + $length);
                $count = ($countLimit + $length);
            }
        }else{
            $splArray->setSize($count + $length);
            $count += $length;
        }

        for ($i = $count - $length; $i >= $offset; $i--) {
            $newIndex = $i + $length;
            if ($newIndex >= $count) {
                continue;
            }
            $tmpItem = $splArray[$i];
            $splArray[$newIndex] = $tmpItem;
            unset($splArray[$i]);
        }
    }

}
