<?php


namespace Gek\Collections\Iterators;


use ArrayIterator;
use Iterator;

/**
 * Class ReverseIterator
 * @package Gek\Collections\Iterators
 */
class ReverseIterator implements Iterator
{
    #region fields

    /**
     * @var Iterator
     */
    protected Iterator $iterator;

    protected ?Iterator $reversedIterator = null;

    #endregion fields

    #region ctor
    /**
     * ReverseIterator constructor.
     * @param Iterator $iterator
     */
    public function __construct(Iterator $iterator)
    {
        $this->iterator = $iterator;
    }

    #endregion ctor

    #region Iterator

    /**
     * Return the current element
     * @link https://php.net/manual/en/iterator.current.php
     * @return mixed Can return any type.
     * @since 5.0.0
     */
    public function current()
    {
        $this->check();
       return $this->reversedIterator->current();
    }

    /**
     * Move forward to next element
     * @link https://php.net/manual/en/iterator.next.php
     * @return void Any returned value is ignored.
     * @since 5.0.0
     */
    public function next()
    {
        $this->check();
        $this->reversedIterator->next();
    }

    /**
     * Return the key of the current element
     * @link https://php.net/manual/en/iterator.key.php
     * @return mixed scalar on success, or null on failure.
     * @since 5.0.0
     */
    public function key()
    {
        $this->check();
        return $this->reversedIterator->key();
    }

    /**
     * Checks if current position is valid
     * @link https://php.net/manual/en/iterator.valid.php
     * @return bool The return value will be casted to boolean and then evaluated.
     * Returns true on success or false on failure.
     * @since 5.0.0
     */
    public function valid()
    {
        $this->check();
        return $this->reversedIterator->valid();
    }

    /**
     * Rewind the Iterator to the first element
     * @link https://php.net/manual/en/iterator.rewind.php
     * @return void Any returned value is ignored.
     * @since 5.0.0
     */
    public function rewind()
    {
        // cache i sil
        $this->reversedIterator = null;
        $this->iterator->rewind();
    }

    #endregion Iterator

    #region utils

    public function check(){
        if($this->reversedIterator !== null){
            return;
        }
        $temp_array = iterator_to_array($this->iterator);
        $temp_array = array_reverse($temp_array);
        $this->reversedIterator = new ArrayIterator($temp_array);
    }

    #endregion utils
}
