<?php


namespace Gek\Collections\Tests;


use Gek\Collections\ArrayList;
use Gek\Collections\Dictionary;
use Gek\Collections\FixedArrayList;
use Gek\Collections\Tests\Fixtures\MockDictionaryItemType;
use Gek\Collections\Tests\Fixtures\MockForTypedDictionaryWrapper;
use Gek\Collections\Tests\Fixtures\MockForTypedListWrapper;
use Gek\Collections\Tests\Fixtures\MockListItemType;
use Gek\Collections\IDictionary;
use Gek\Collections\IList;
use PHPUnit\Framework\TestCase;

class TypedDictionaryWrapperTest extends TestCase
{

    public function testCtor():void {
        $dictionary = new Dictionary();
        $mock = new MockForTypedDictionaryWrapper($dictionary,'int');

        $this->assertEquals(
            'int',
            $mock->getItemType()
        );
        $this->assertEquals(
            $dictionary,
            $mock->getInnerDictionary()
        );
        $this->assertTrue(
            $dictionary === $mock->getInnerDictionary()
        );

        $this->assertEquals(
            $dictionary,
            $mock->getEnm()
        );
        $this->assertTrue(
            $dictionary === $mock->getEnm()
        );



        /**/
        $mock = new MockForTypedDictionaryWrapper($dictionary,MockDictionaryItemType::class);

        $this->assertEquals(
            MockDictionaryItemType::class,
            $mock->getItemType()
        );

        $this->assertTrue(
            $dictionary === $mock->getInnerDictionary()
        );

        $this->assertTrue(
            $dictionary === $mock->getEnm()
        );
    }

    public function testGetInnerDictionary():void {
        $list = new Dictionary();
        $mock = new MockForTypedDictionaryWrapper($list,'int');

        $this->assertEquals(
            $list,
            $mock->getInnerDictionary()
        );
        $this->assertTrue(
            $list === $mock->getInnerDictionary()
        );
        $this->assertInstanceOf(
            IDictionary::class,
            $mock->getInnerDictionary()
        );
    }

    #region serializable

    public function testSerializable(){
        $arr = [
            'a' => 0,
            'b' => 1,
            'c' => 2,
            'd' => 3,
            'e' => 4,
            'f' => 5,
            'g' => 6,
            'h' => 7,
        ];
        $dictionary = new Dictionary($arr);
        $mock = new MockForTypedDictionaryWrapper($dictionary,'int');

        $ser = serialize($mock);
        $this->assertNotEmpty($ser);
        $this->assertIsString($ser);
        /** @var  MockForTypedDictionaryWrapper $unSer */
        $unSer = unserialize($ser);
        $this->assertTrue($unSer instanceof MockForTypedDictionaryWrapper);
        $this->assertEquals($mock , $unSer);
        $this->assertFalse($mock === $unSer);
        $this->assertEquals(
            $mock->toArray(true),
            $unSer->toArray(true)
        );
        $this->assertEquals(
            $arr,
            $unSer->toArray(true)
        );
    }

    public function testNonSerializable1(){

        $dictionary = new Dictionary();
        $mock = new MockForTypedDictionaryWrapper($dictionary,'closure');
        $this->expectException(\LogicException::class);
        $this->expectExceptionMessage('Öğe tipi (closure) serileştirilebilir bir tip değil.');
        $ser = serialize($mock);

    }
    public function testNonSerializable2(){
        $dictionary = new Dictionary();
        $mock = new MockForTypedDictionaryWrapper($dictionary,'callable');
        $this->expectException(\LogicException::class);
        $this->expectExceptionMessage('Öğe tipi (callable) serileştirilebilir bir tip değil.');
        $ser = serialize($mock);

    }

    public function testNonSerializable3(){
        $dictionary = new Dictionary();
        $mock = new MockForTypedDictionaryWrapper($dictionary,'resource');
        $this->expectException(\LogicException::class);
        $this->expectExceptionMessage('Öğe tipi (resource) serileştirilebilir bir tip değil.');
        $ser = serialize($mock);

    }

    #endregion serializable

}