<?php


namespace Gek\Collections\Typed;


use Gek\Collections\Dictionary;
use Gek\Collections\Enumerable;
use Gek\Collections\TypedDictionaryWrapper;

/**
 * Class TArrayDictionary
 * @package Gek\Collections\Typed
 */
class TArrayDictionary extends TypedDictionaryWrapper
{
    #region ctor
    /**
     * TArrayDictionary constructor.
     * @param Dictionary|array|Enumerable|\Traversable|null $values
     */
    public function __construct($values = null)
    {
        parent::__construct(new Dictionary(), 'array');
        if($values != null)
        {
            $this->addRange($values);
        }
    }
    #endregion ctor

    #region methods

    /**
     * @param array $item
     */
    public function add(array $item):void {
        $this->innerDictionary->add($item);
    }


    /**
     * @param Dictionary|array|Enumerable|\Traversable $items
     */
    public function addRange($items): void
    {
        foreach ($items as $key => $value){
            $this->addKeyValue($key,$value);
        }
    }

    /**
     * @param array $item
     * @return bool
     */
    public function contains(array $item): bool{
        return $this->innerDictionary->contains($item);
    }

    /**
     * @param array $item
     * @return bool
     */
    public function remove(array $item): bool{
        return $this->innerDictionary->remove($item);
    }

    /**
     * @param string $key
     * @param array $value
     */
    public function addKeyValue(string $key, array $value): void{
        $this->innerDictionary->addKeyValue($key,$value);
    }

    /**
     * @param string $key
     * @param array $value
     * @return bool
     */
    public function tryAddKeyValue(string $key, array $value):bool{
        return $this->innerDictionary->tryAddKeyValue($key,$value);
    }

    /**
     * @param string $key
     * @return array
     */
    public function getByKey(string $key):array {
        return $this->innerDictionary[$key];
    }

    /**
     * @param string $key
     * @param array $item
     */
    public function setByKey(string $key, array $item):void {
        $this->innerDictionary[$key] = $item;
    }

    #endregion methods
}
