<?php


namespace Gek\Collections\Iterators;


use Iterator;

/**
 * Class ExceptIterator
 * @package Gek\Collections\Iterators
 */
class ExceptIterator implements Iterator
{

    #region fields

    protected Iterator $iterator;

    protected  Iterator $exceptedIterator;

    protected ?array $tempArray = null;

    #endregion fields

    #region ctor
    /**
     * ExceptIterator constructor.
     * @param Iterator $iterator
     * @param Iterator $exceptedIterator
     */
    public function __construct(Iterator $iterator, Iterator $exceptedIterator)
    {
        $this->iterator = $iterator;
        $this->exceptedIterator = $exceptedIterator;
    }

    #endregion ctor

    #region Iterator

    /**
     * Return the current element
     * @link https://php.net/manual/en/iterator.current.php
     * @return mixed Can return any type.
     * @since 5.0.0
     */
    public function current()
    {
        $this->check();
        return  $this->iterator->current();
    }

    /**
     * Move forward to next element
     * @link https://php.net/manual/en/iterator.next.php
     * @return void Any returned value is ignored.
     * @since 5.0.0
     */
    public function next()
    {
        $this->check();
        $this->iterator->next();
        while($this->iterator->valid() && in_array($this->iterator->current(),$this->tempArray)){
            $this->iterator->next();
        }
    }

    /**
     * Return the key of the current element
     * @link https://php.net/manual/en/iterator.key.php
     * @return mixed scalar on success, or null on failure.
     * @since 5.0.0
     */
    public function key()
    {
        $this->check();
        return $this->iterator->key();
    }

    /**
     * Checks if current position is valid
     * @link https://php.net/manual/en/iterator.valid.php
     * @return bool The return value will be casted to boolean and then evaluated.
     * Returns true on success or false on failure.
     * @since 5.0.0
     */
    public function valid()
    {
        $this->check();
        return $this->iterator->valid();
    }

    /**
     * Rewind the Iterator to the first element
     * @link https://php.net/manual/en/iterator.rewind.php
     * @return void Any returned value is ignored.
     * @since 5.0.0
     */
    public function rewind()
    {
        $this->tempArray = null;
        $this->iterator->rewind();
    }

    #endregion Iterator

    #region utils

    protected function check(){
        if($this->tempArray !== null){
            return;
        }
        $this->tempArray = iterator_to_array($this->exceptedIterator);
    }

    #endregion utils

}
