<?php


namespace Gek\Collections\Iterators;


use Gek\Collections\ArrayList;
use Iterator;

/**
 * Class ArrayListIterator
 * @package Gek\Collections\Iterators
 */
class ArrayListIterator implements Iterator
{

    #region fields

    protected ArrayList $arrayList;

    protected int $position = 0;

    #endregion fields

    /**
     * FixedArrayListIterator constructor.
     * @param ArrayList $arrayList
     */
    public function __construct(ArrayList $arrayList)
    {
        $this->arrayList = $arrayList;
    }

    #region Iterator

    /**
     * Return the current element
     * @link https://php.net/manual/en/iterator.current.php
     * @return mixed Can return any type.
     * @since 5.0.0
     */
    public function current()
    {
        return $this->arrayList[$this->position];
    }

    /**
     * Move forward to next element
     * @link https://php.net/manual/en/iterator.next.php
     * @return void Any returned value is ignored.
     * @since 5.0.0
     */
    public function next()
    {
        ++$this->position;
    }

    /**
     * Return the key of the current element
     * @link https://php.net/manual/en/iterator.key.php
     * @return mixed scalar on success, or null on failure.
     * @since 5.0.0
     */
    public function key()
    {
        return $this->position;
    }

    /**
     * Checks if current position is valid
     * @link https://php.net/manual/en/iterator.valid.php
     * @return bool The return value will be casted to boolean and then evaluated.
     * Returns true on success or false on failure.
     * @since 5.0.0
     */
    public function valid()
    {
        return $this->position < $this->arrayList->count();
    }

    /**
     * Rewind the Iterator to the first element
     * @link https://php.net/manual/en/iterator.rewind.php
     * @return void Any returned value is ignored.
     * @since 5.0.0
     */
    public function rewind()
    {
        $this->position = 0;
    }

    #endregion Iterator
}
