<?php


namespace Gek\Collections;

/**
 * Interface ICollection
 * @package Gek\Collections
 */
interface ICollection extends IEnumerable
{

    /**
     * @param mixed $item
     */
    public function add($item):void;

    /**
     * @param array|Enumerable|\IteratorAggregate|\Iterator|\Traversable $items
     */
    public function addRange($items):void;

    /**
     *
     */
    public function clear():void;

    /**
     * @param mixed $item
     * @return bool
     */
    public function contains($item):bool;

    /**
     * @param mixed $item
     * @return bool
     */
    public function remove($item):bool;



}
