<?php


namespace Gek\Captcha\Tests;


use Gek\Captcha\PhraseBuilder;
use PHPUnit\Framework\TestCase;
use function Webmozart\Assert\Tests\StaticAnalysis\null;

class PhraseBuilderTest extends TestCase
{

    public function testConstruct(){

        $reflect = new \ReflectionClass(PhraseBuilder::class);

        $charLengthProp = $reflect->getProperty('charLength');
        $charLengthProp->setAccessible(true);

        $allowedCharsProp = $reflect->getProperty('allowedChars');
        $allowedCharsProp->setAccessible(true);


        $builder = new PhraseBuilder();

        $this->assertEquals(
            6,
            $charLengthProp->getValue($builder)
        );

        $this->assertEquals(
            'abcdefghkmnpqrstuvwxyzABCDEFGHJKLMNOPQRSTUVWXYZ23456789',
            $allowedCharsProp->getValue($builder)
        );

        $builder = new PhraseBuilder(8);

        $this->assertEquals(
            8,
            $charLengthProp->getValue($builder)
        );
    }

    public function testSetters(){
        $reflect = new \ReflectionClass(PhraseBuilder::class);

        $charLengthProp = $reflect->getProperty('charLength');
        $charLengthProp->setAccessible(true);

        $allowedCharsProp = $reflect->getProperty('allowedChars');
        $allowedCharsProp->setAccessible(true);


        $builder = new PhraseBuilder();

        $builder->setCharLength(12);

        $this->assertEquals(
            12,
            $charLengthProp->getValue($builder)
        );
        $builder->setCharLength(5);

        $this->assertEquals(
            5,
            $charLengthProp->getValue($builder)
        );

        $builder->setAllowedChars('qwertyuıopğü789');

        $this->assertEquals(
            'qwertyuıopğü789',
            $allowedCharsProp->getValue($builder)
        );
        $builder->setAllowedChars('asdfghjklşi456');

        $this->assertEquals(
            'asdfghjklşi456',
            $allowedCharsProp->getValue($builder)
        );

    }

    public function testGetters(){
        $builder = new PhraseBuilder();

        $this->assertEquals(
            6,
            $builder->getCharLength()
        );

        $builder->setCharLength(4);

        $this->assertEquals(
            4,
            $builder->getCharLength()
        );

        $this->assertEquals(
            'abcdefghkmnpqrstuvwxyzABCDEFGHJKLMNOPQRSTUVWXYZ23456789',
            $builder->getAllowedChars()
        );

        $builder->setAllowedChars('qwertyuıopğü789');

        $this->assertEquals(
            'qwertyuıopğü789',
            $builder->getAllowedChars()
        );
        $builder->setAllowedChars('asdfghjklşi456');

        $this->assertEquals(
            'asdfghjklşi456',
            $builder->getAllowedChars()
        );

    }

    public function testBuild(){
        $builder = new PhraseBuilder();

        $phrase = $builder->build();
        $this->assertEquals(
            6,
            mb_strlen($phrase)
        );
        $phrase = $builder->build(8);
        $this->assertEquals(
            8,
            mb_strlen($phrase)
        );

        $phrase = $builder->build();
        $this->assertEquals(
            6,
            mb_strlen($phrase)
        );

        $builder->setCharLength(22);

        $phrase = $builder->build();
        $this->assertEquals(
            22,
            mb_strlen($phrase)
        );

        $phrase = $builder->build(4);
        $this->assertEquals(
            4,
            mb_strlen($phrase)
        );

        $builder = new PhraseBuilder();
        $builder->setAllowedChars('A');

        $phrase = $builder->build();

        $this->assertEquals(
            'AAAAAA',
            $phrase
        );
    }

    public function testEqualsPhrase(){
        $this->assertTrue(
            PhraseBuilder::equalsPhrase('abcd123','abcd123')
        );
        $this->assertFalse(
            PhraseBuilder::equalsPhrase('abCD123','abcd123')
        );
        $this->assertTrue(
            PhraseBuilder::equalsPhrase('abCD123','abcd123',false)
        );
        $this->assertFalse(
            PhraseBuilder::equalsPhrase('abCD123şğiÖ','abcd123ŞĞİö')
        );
        $this->assertTrue(
            PhraseBuilder::equalsPhrase('abCD123şğiÖ','abcd123ŞĞİö',false,null,'tr')
        );
        $this->assertFalse(
            PhraseBuilder::equalsPhrase('abCD123şğiÖ','abcd123ŞĞİö',true,null,'tr')
        );
        $this->assertTrue(
            PhraseBuilder::equalsPhrase('abCD123şğİÖ','abCD123şğİÖ')
        );
    }

    public function testBuildPhrase(){
        $phrase = PhraseBuilder::buildPhrase();

        $this->assertEquals(
            6,
            mb_strlen($phrase)
        );

        $phrase = PhraseBuilder::buildPhrase(8);

        $this->assertEquals(
            8,
            mb_strlen($phrase)
        );

        $phrase = PhraseBuilder::buildPhrase(null,'A');

        $this->assertEquals(
            6,
            mb_strlen($phrase)
        );
        $this->assertEquals(
            'AAAAAA',
            $phrase
        );

        $phrase = PhraseBuilder::buildPhrase(3,'B');

        $this->assertEquals(
            3,
            mb_strlen($phrase)
        );
        $this->assertEquals(
            'BBB',
            $phrase
        );
    }
}