<?php


namespace Gek\Captcha\Tests;


use Gek\Captcha\RgbColor;
use PHPUnit\Framework\TestCase;

class RgbColorTest extends TestCase
{
    public function testConstruct(): void
    {

        $reflect = new \ReflectionClass(RgbColor::class);

        $rProp = $reflect->getProperty('r');
        $rProp->setAccessible(true);

        $gProp = $reflect->getProperty('g');
        $gProp->setAccessible(true);

        $bProp = $reflect->getProperty('b');
        $bProp->setAccessible(true);

        $rgb = new RgbColor();

        $this->assertEquals(
            0,
            $rProp->getValue($rgb)
        );

        $this->assertEquals(
            0,
            $gProp->getValue($rgb)
        );

        $this->assertEquals(
            0,
            $bProp->getValue($rgb)
        );

        $rgb = new RgbColor(18, 78, 200);


        $this->assertEquals(
            18,
            $rProp->getValue($rgb)
        );

        $this->assertEquals(
            78,
            $gProp->getValue($rgb)
        );

        $this->assertEquals(
            200,
            $bProp->getValue($rgb)
        );

        $rgb = new RgbColor(18, 811, 200);

        $this->assertEquals(
            18,
            $rProp->getValue($rgb)
        );

        $this->assertEquals(
            255,
            $gProp->getValue($rgb)
        );

        $this->assertEquals(
            200,
            $bProp->getValue($rgb)
        );


        $rgb = new RgbColor(127, 811, -15);


        $this->assertEquals(
            127,
            $rProp->getValue($rgb)
        );

        $this->assertEquals(
            255,
            $gProp->getValue($rgb)
        );

        $this->assertEquals(
            0,
            $bProp->getValue($rgb)
        );

    }

    public function testGetters()
    {
        $rgb = new RgbColor(15, 48, 158);

        $this->assertEquals(
            15,
            $rgb->getR()
        );
        $this->assertEquals(
            48,
            $rgb->getG()
        );
        $this->assertEquals(
            158,
            $rgb->getB()
        );
    }

    public function testSetters()
    {
        $rgb = new RgbColor();

        $rgb->setR(15);
        $this->assertEquals(
            15,
            $rgb->getR()
        );

        $rgb->setR(-15);
        $this->assertEquals(
            0,
            $rgb->getR()
        );

        $rgb->setR(500);
        $this->assertEquals(
            255,
            $rgb->getR()
        );


        $rgb->setG(15);
        $this->assertEquals(
            15,
            $rgb->getG()
        );

        $rgb->setG(-15);
        $this->assertEquals(
            0,
            $rgb->getG()
        );

        $rgb->setG(500);
        $this->assertEquals(
            255,
            $rgb->getG()
        );

        $rgb->setB(15);
        $this->assertEquals(
            15,
            $rgb->getB()
        );

        $rgb->setB(-15);
        $this->assertEquals(
            0,
            $rgb->getB()
        );

        $rgb->setB(500);
        $this->assertEquals(
            255,
            $rgb->getB()
        );

    }

    public function testToArray()
    {
        $rgb = new RgbColor(45, 78, 215);

        $this->assertEquals(
            [45, 78, 215],
            $rgb->toArray()
        );
    }

    public function testToFromInt()
    {
        $rgb = new RgbColor(158, 125, 87);

        $this->assertEquals(
            10386775,
            $rgb->toInt()
        );
        $rgb = new RgbColor();
        $rgb->fromInt(10386775);

        $this->assertEquals(
            [158, 125, 87],
            $rgb->toArray()
        );

        $this->assertEquals(
            10386775,
            $rgb->toInt()
        );
    }

    public function testCreate(){
        $controlRgb = new RgbColor();
        $createdRgb = RgbColor::create();

        $this->assertEquals(
            $controlRgb,
            $createdRgb
        );

        $createdRgb = RgbColor::create(15,45,158);
        $this->assertNotEquals(
            $controlRgb,
            $createdRgb
        );

        $controlRgb = new RgbColor(65,78,250);
        $createdRgb = RgbColor::create(65,78,250);
        $this->assertEquals(
            $controlRgb,
            $createdRgb
        );

    }

    public function testCreateFromInt(){
        $controlRgb = new RgbColor();
        $controlRgb->fromInt(10386775);

        $createdRgb = RgbColor::createFromInt(10386775);

        $this->assertEquals(
            $controlRgb,
            $createdRgb
        );
    }

}